package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListInvitationsResponse(
    invitations: Optional[Iterable[zio.aws.guardduty.model.Invitation]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse = {
    import ListInvitationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse
      .builder()
      .optionallyWith(
        invitations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.invitations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ListInvitationsResponse.ReadOnly =
    zio.aws.guardduty.model.ListInvitationsResponse.wrap(buildAwsValue())
}
object ListInvitationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ListInvitationsResponse =
      zio.aws.guardduty.model.ListInvitationsResponse(
        invitations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def invitations: Optional[List[zio.aws.guardduty.model.Invitation.ReadOnly]]
    def nextToken: Optional[String]
    def getInvitations: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.Invitation.ReadOnly
    ]] = AwsError.unwrapOptionField("invitations", invitations)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse
  ) extends zio.aws.guardduty.model.ListInvitationsResponse.ReadOnly {
    override val invitations
        : Optional[List[zio.aws.guardduty.model.Invitation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invitations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.Invitation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse
  ): zio.aws.guardduty.model.ListInvitationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
