package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListIpSetsResponse(
    ipSetIds: Iterable[String],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse = {
    import ListIpSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse
      .builder()
      .ipSetIds(ipSetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ListIpSetsResponse.ReadOnly =
    zio.aws.guardduty.model.ListIpSetsResponse.wrap(buildAwsValue())
}
object ListIpSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ListIpSetsResponse =
      zio.aws.guardduty.model
        .ListIpSetsResponse(ipSetIds, nextToken.map(value => value))
    def ipSetIds: List[String]
    def nextToken: Optional[String]
    def getIpSetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(ipSetIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse
  ) extends zio.aws.guardduty.model.ListIpSetsResponse.ReadOnly {
    override val ipSetIds: List[String] = impl
      .ipSetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse
  ): zio.aws.guardduty.model.ListIpSetsResponse.ReadOnly = new Wrapper(impl)
}
