package zio.aws.guardduty.model
import zio.aws.guardduty.model.primitives.{MaxResults, DetectorId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMembersRequest(
    detectorId: DetectorId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    onlyAssociated: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ListMembersRequest = {
    import ListMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ListMembersRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(onlyAssociated.map(value => value: java.lang.String))(
        _.onlyAssociated
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ListMembersRequest.ReadOnly =
    zio.aws.guardduty.model.ListMembersRequest.wrap(buildAwsValue())
}
object ListMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ListMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ListMembersRequest =
      zio.aws.guardduty.model.ListMembersRequest(
        detectorId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        onlyAssociated.map(value => value)
      )
    def detectorId: DetectorId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[String]
    def onlyAssociated: Optional[String]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOnlyAssociated: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("onlyAssociated", onlyAssociated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ListMembersRequest
  ) extends zio.aws.guardduty.model.ListMembersRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.guardduty.model.primitives.MaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val onlyAssociated: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.onlyAssociated())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ListMembersRequest
  ): zio.aws.guardduty.model.ListMembersRequest.ReadOnly = new Wrapper(impl)
}
