package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListMembersResponse(
    members: Optional[Iterable[zio.aws.guardduty.model.Member]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ListMembersResponse = {
    import ListMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ListMembersResponse
      .builder()
      .optionallyWith(
        members.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.members)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ListMembersResponse.ReadOnly =
    zio.aws.guardduty.model.ListMembersResponse.wrap(buildAwsValue())
}
object ListMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ListMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ListMembersResponse =
      zio.aws.guardduty.model.ListMembersResponse(
        members.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def members: Optional[List[zio.aws.guardduty.model.Member.ReadOnly]]
    def nextToken: Optional[String]
    def getMembers
        : ZIO[Any, AwsError, List[zio.aws.guardduty.model.Member.ReadOnly]] =
      AwsError.unwrapOptionField("members", members)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ListMembersResponse
  ) extends zio.aws.guardduty.model.ListMembersResponse.ReadOnly {
    override val members
        : Optional[List[zio.aws.guardduty.model.Member.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.members())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.Member.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ListMembersResponse
  ): zio.aws.guardduty.model.ListMembersResponse.ReadOnly = new Wrapper(impl)
}
