package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListOrganizationAdminAccountsResponse(
    adminAccounts: Optional[Iterable[zio.aws.guardduty.model.AdminAccount]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse = {
    import ListOrganizationAdminAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse
      .builder()
      .optionallyWith(
        adminAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adminAccounts)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.ListOrganizationAdminAccountsResponse.ReadOnly =
    zio.aws.guardduty.model.ListOrganizationAdminAccountsResponse
      .wrap(buildAwsValue())
}
object ListOrganizationAdminAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.ListOrganizationAdminAccountsResponse =
      zio.aws.guardduty.model.ListOrganizationAdminAccountsResponse(
        adminAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def adminAccounts
        : Optional[List[zio.aws.guardduty.model.AdminAccount.ReadOnly]]
    def nextToken: Optional[String]
    def getAdminAccounts: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.AdminAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("adminAccounts", adminAccounts)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse
  ) extends zio.aws.guardduty.model.ListOrganizationAdminAccountsResponse.ReadOnly {
    override val adminAccounts
        : Optional[List[zio.aws.guardduty.model.AdminAccount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adminAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.AdminAccount.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse
  ): zio.aws.guardduty.model.ListOrganizationAdminAccountsResponse.ReadOnly =
    new Wrapper(impl)
}
