package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPublishingDestinationsResponse(
    destinations: Iterable[zio.aws.guardduty.model.Destination],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse = {
    import ListPublishingDestinationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse
      .builder()
      .destinations(destinations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.ListPublishingDestinationsResponse.ReadOnly =
    zio.aws.guardduty.model.ListPublishingDestinationsResponse
      .wrap(buildAwsValue())
}
object ListPublishingDestinationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ListPublishingDestinationsResponse =
      zio.aws.guardduty.model.ListPublishingDestinationsResponse(
        destinations.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def destinations: List[zio.aws.guardduty.model.Destination.ReadOnly]
    def nextToken: Optional[String]
    def getDestinations: ZIO[Any, Nothing, List[
      zio.aws.guardduty.model.Destination.ReadOnly
    ]] = ZIO.succeed(destinations)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse
  ) extends zio.aws.guardduty.model.ListPublishingDestinationsResponse.ReadOnly {
    override val destinations
        : List[zio.aws.guardduty.model.Destination.ReadOnly] = impl
      .destinations()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.Destination.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse
  ): zio.aws.guardduty.model.ListPublishingDestinationsResponse.ReadOnly =
    new Wrapper(impl)
}
