package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.GuardDutyArn
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: GuardDutyArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(GuardDutyArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.guardduty.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ListTagsForResourceRequest =
      zio.aws.guardduty.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: GuardDutyArn
    def getResourceArn: ZIO[Any, Nothing, GuardDutyArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ListTagsForResourceRequest
  ) extends zio.aws.guardduty.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: GuardDutyArn =
      zio.aws.guardduty.model.primitives.GuardDutyArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ListTagsForResourceRequest
  ): zio.aws.guardduty.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
