package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListThreatIntelSetsResponse(
    threatIntelSetIds: Iterable[String],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse = {
    import ListThreatIntelSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse
      .builder()
      .threatIntelSetIds(threatIntelSetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ListThreatIntelSetsResponse.ReadOnly =
    zio.aws.guardduty.model.ListThreatIntelSetsResponse.wrap(buildAwsValue())
}
object ListThreatIntelSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ListThreatIntelSetsResponse =
      zio.aws.guardduty.model.ListThreatIntelSetsResponse(
        threatIntelSetIds,
        nextToken.map(value => value)
      )
    def threatIntelSetIds: List[String]
    def nextToken: Optional[String]
    def getThreatIntelSetIds: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(threatIntelSetIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse
  ) extends zio.aws.guardduty.model.ListThreatIntelSetsResponse.ReadOnly {
    override val threatIntelSetIds: List[String] = impl
      .threatIntelSetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse
  ): zio.aws.guardduty.model.ListThreatIntelSetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
