package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LocalIpDetails(
    ipAddressV4: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.LocalIpDetails = {
    import LocalIpDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.LocalIpDetails
      .builder()
      .optionallyWith(ipAddressV4.map(value => value: java.lang.String))(
        _.ipAddressV4
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.LocalIpDetails.ReadOnly =
    zio.aws.guardduty.model.LocalIpDetails.wrap(buildAwsValue())
}
object LocalIpDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.LocalIpDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.LocalIpDetails =
      zio.aws.guardduty.model.LocalIpDetails(ipAddressV4.map(value => value))
    def ipAddressV4: Optional[String]
    def getIpAddressV4: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipAddressV4", ipAddressV4)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.LocalIpDetails
  ) extends zio.aws.guardduty.model.LocalIpDetails.ReadOnly {
    override val ipAddressV4: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddressV4())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.LocalIpDetails
  ): zio.aws.guardduty.model.LocalIpDetails.ReadOnly = new Wrapper(impl)
}
