package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class LocalPortDetails(
    port: Optional[Integer] = Optional.Absent,
    portName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.LocalPortDetails = {
    import LocalPortDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.LocalPortDetails
      .builder()
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(portName.map(value => value: java.lang.String))(
        _.portName
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.LocalPortDetails.ReadOnly =
    zio.aws.guardduty.model.LocalPortDetails.wrap(buildAwsValue())
}
object LocalPortDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.LocalPortDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.LocalPortDetails =
      zio.aws.guardduty.model.LocalPortDetails(
        port.map(value => value),
        portName.map(value => value)
      )
    def port: Optional[Integer]
    def portName: Optional[String]
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getPortName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("portName", portName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.LocalPortDetails
  ) extends zio.aws.guardduty.model.LocalPortDetails.ReadOnly {
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val portName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.portName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.LocalPortDetails
  ): zio.aws.guardduty.model.LocalPortDetails.ReadOnly = new Wrapper(impl)
}
