package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MalwareProtectionConfigurationResult(
    scanEc2InstanceWithFindings: Optional[
      zio.aws.guardduty.model.ScanEc2InstanceWithFindingsResult
    ] = Optional.Absent,
    serviceRole: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.MalwareProtectionConfigurationResult = {
    import MalwareProtectionConfigurationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.MalwareProtectionConfigurationResult
      .builder()
      .optionallyWith(
        scanEc2InstanceWithFindings.map(value => value.buildAwsValue())
      )(_.scanEc2InstanceWithFindings)
      .optionallyWith(serviceRole.map(value => value: java.lang.String))(
        _.serviceRole
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.MalwareProtectionConfigurationResult.ReadOnly =
    zio.aws.guardduty.model.MalwareProtectionConfigurationResult
      .wrap(buildAwsValue())
}
object MalwareProtectionConfigurationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.MalwareProtectionConfigurationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.MalwareProtectionConfigurationResult =
      zio.aws.guardduty.model.MalwareProtectionConfigurationResult(
        scanEc2InstanceWithFindings.map(value => value.asEditable),
        serviceRole.map(value => value)
      )
    def scanEc2InstanceWithFindings: Optional[
      zio.aws.guardduty.model.ScanEc2InstanceWithFindingsResult.ReadOnly
    ]
    def serviceRole: Optional[String]
    def getScanEc2InstanceWithFindings: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.ScanEc2InstanceWithFindingsResult.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scanEc2InstanceWithFindings",
      scanEc2InstanceWithFindings
    )
    def getServiceRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.MalwareProtectionConfigurationResult
  ) extends zio.aws.guardduty.model.MalwareProtectionConfigurationResult.ReadOnly {
    override val scanEc2InstanceWithFindings: Optional[
      zio.aws.guardduty.model.ScanEc2InstanceWithFindingsResult.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scanEc2InstanceWithFindings())
      .map(value =>
        zio.aws.guardduty.model.ScanEc2InstanceWithFindingsResult.wrap(value)
      )
    override val serviceRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.MalwareProtectionConfigurationResult
  ): zio.aws.guardduty.model.MalwareProtectionConfigurationResult.ReadOnly =
    new Wrapper(impl)
}
