package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MalwareProtectionDataSourceFreeTrial(
    scanEc2InstanceWithFindings: Optional[
      zio.aws.guardduty.model.DataSourceFreeTrial
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.MalwareProtectionDataSourceFreeTrial = {
    import MalwareProtectionDataSourceFreeTrial.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.MalwareProtectionDataSourceFreeTrial
      .builder()
      .optionallyWith(
        scanEc2InstanceWithFindings.map(value => value.buildAwsValue())
      )(_.scanEc2InstanceWithFindings)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.MalwareProtectionDataSourceFreeTrial.ReadOnly =
    zio.aws.guardduty.model.MalwareProtectionDataSourceFreeTrial
      .wrap(buildAwsValue())
}
object MalwareProtectionDataSourceFreeTrial {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.MalwareProtectionDataSourceFreeTrial
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.MalwareProtectionDataSourceFreeTrial =
      zio.aws.guardduty.model.MalwareProtectionDataSourceFreeTrial(
        scanEc2InstanceWithFindings.map(value => value.asEditable)
      )
    def scanEc2InstanceWithFindings
        : Optional[zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly]
    def getScanEc2InstanceWithFindings: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scanEc2InstanceWithFindings",
      scanEc2InstanceWithFindings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.MalwareProtectionDataSourceFreeTrial
  ) extends zio.aws.guardduty.model.MalwareProtectionDataSourceFreeTrial.ReadOnly {
    override val scanEc2InstanceWithFindings
        : Optional[zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanEc2InstanceWithFindings())
        .map(value => zio.aws.guardduty.model.DataSourceFreeTrial.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.MalwareProtectionDataSourceFreeTrial
  ): zio.aws.guardduty.model.MalwareProtectionDataSourceFreeTrial.ReadOnly =
    new Wrapper(impl)
}
