package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{Email, DetectorId, AccountId}
import scala.jdk.CollectionConverters.*
final case class Member(
    accountId: AccountId,
    detectorId: Optional[DetectorId] = Optional.Absent,
    masterId: String,
    email: Email,
    relationshipStatus: String,
    invitedAt: Optional[String] = Optional.Absent,
    updatedAt: String,
    administratorId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.Member = {
    import Member.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Member
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(
        detectorId.map(value => DetectorId.unwrap(value): java.lang.String)
      )(_.detectorId)
      .masterId(masterId: java.lang.String)
      .email(Email.unwrap(email): java.lang.String)
      .relationshipStatus(relationshipStatus: java.lang.String)
      .optionallyWith(invitedAt.map(value => value: java.lang.String))(
        _.invitedAt
      )
      .updatedAt(updatedAt: java.lang.String)
      .optionallyWith(administratorId.map(value => value: java.lang.String))(
        _.administratorId
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Member.ReadOnly =
    zio.aws.guardduty.model.Member.wrap(buildAwsValue())
}
object Member {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.guardduty.model.Member] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Member =
      zio.aws.guardduty.model.Member(
        accountId,
        detectorId.map(value => value),
        masterId,
        email,
        relationshipStatus,
        invitedAt.map(value => value),
        updatedAt,
        administratorId.map(value => value)
      )
    def accountId: AccountId
    def detectorId: Optional[DetectorId]
    def masterId: String
    def email: Email
    def relationshipStatus: String
    def invitedAt: Optional[String]
    def updatedAt: String
    def administratorId: Optional[String]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getDetectorId: ZIO[Any, AwsError, DetectorId] =
      AwsError.unwrapOptionField("detectorId", detectorId)
    def getMasterId: ZIO[Any, Nothing, String] = ZIO.succeed(masterId)
    def getEmail: ZIO[Any, Nothing, Email] = ZIO.succeed(email)
    def getRelationshipStatus: ZIO[Any, Nothing, String] =
      ZIO.succeed(relationshipStatus)
    def getInvitedAt: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("invitedAt", invitedAt)
    def getUpdatedAt: ZIO[Any, Nothing, String] = ZIO.succeed(updatedAt)
    def getAdministratorId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("administratorId", administratorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Member
  ) extends zio.aws.guardduty.model.Member.ReadOnly {
    override val accountId: AccountId =
      zio.aws.guardduty.model.primitives.AccountId(impl.accountId())
    override val detectorId: Optional[DetectorId] = zio.aws.core.internal
      .optionalFromNullable(impl.detectorId())
      .map(value => zio.aws.guardduty.model.primitives.DetectorId(value))
    override val masterId: String = impl.masterId(): String
    override val email: Email =
      zio.aws.guardduty.model.primitives.Email(impl.email())
    override val relationshipStatus: String = impl.relationshipStatus(): String
    override val invitedAt: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.invitedAt())
      .map(value => value: String)
    override val updatedAt: String = impl.updatedAt(): String
    override val administratorId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.administratorId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Member
  ): zio.aws.guardduty.model.Member.ReadOnly = new Wrapper(impl)
}
