package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class MemberDataSourceConfiguration(
    accountId: AccountId,
    dataSources: zio.aws.guardduty.model.DataSourceConfigurationsResult
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.MemberDataSourceConfiguration = {
    import MemberDataSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.MemberDataSourceConfiguration
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .dataSources(dataSources.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.MemberDataSourceConfiguration.ReadOnly =
    zio.aws.guardduty.model.MemberDataSourceConfiguration.wrap(buildAwsValue())
}
object MemberDataSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.MemberDataSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.MemberDataSourceConfiguration =
      zio.aws.guardduty.model
        .MemberDataSourceConfiguration(accountId, dataSources.asEditable)
    def accountId: AccountId
    def dataSources
        : zio.aws.guardduty.model.DataSourceConfigurationsResult.ReadOnly
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getDataSources: ZIO[
      Any,
      Nothing,
      zio.aws.guardduty.model.DataSourceConfigurationsResult.ReadOnly
    ] = ZIO.succeed(dataSources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.MemberDataSourceConfiguration
  ) extends zio.aws.guardduty.model.MemberDataSourceConfiguration.ReadOnly {
    override val accountId: AccountId =
      zio.aws.guardduty.model.primitives.AccountId(impl.accountId())
    override val dataSources
        : zio.aws.guardduty.model.DataSourceConfigurationsResult.ReadOnly =
      zio.aws.guardduty.model.DataSourceConfigurationsResult
        .wrap(impl.dataSources())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.MemberDataSourceConfiguration
  ): zio.aws.guardduty.model.MemberDataSourceConfiguration.ReadOnly =
    new Wrapper(impl)
}
