package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetworkConnectionAction(
    blocked: Optional[Boolean] = Optional.Absent,
    connectionDirection: Optional[String] = Optional.Absent,
    localPortDetails: Optional[zio.aws.guardduty.model.LocalPortDetails] =
      Optional.Absent,
    protocol: Optional[String] = Optional.Absent,
    localIpDetails: Optional[zio.aws.guardduty.model.LocalIpDetails] =
      Optional.Absent,
    remoteIpDetails: Optional[zio.aws.guardduty.model.RemoteIpDetails] =
      Optional.Absent,
    remotePortDetails: Optional[zio.aws.guardduty.model.RemotePortDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.NetworkConnectionAction = {
    import NetworkConnectionAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.NetworkConnectionAction
      .builder()
      .optionallyWith(blocked.map(value => value: java.lang.Boolean))(_.blocked)
      .optionallyWith(
        connectionDirection.map(value => value: java.lang.String)
      )(_.connectionDirection)
      .optionallyWith(localPortDetails.map(value => value.buildAwsValue()))(
        _.localPortDetails
      )
      .optionallyWith(protocol.map(value => value: java.lang.String))(
        _.protocol
      )
      .optionallyWith(localIpDetails.map(value => value.buildAwsValue()))(
        _.localIpDetails
      )
      .optionallyWith(remoteIpDetails.map(value => value.buildAwsValue()))(
        _.remoteIpDetails
      )
      .optionallyWith(remotePortDetails.map(value => value.buildAwsValue()))(
        _.remotePortDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.NetworkConnectionAction.ReadOnly =
    zio.aws.guardduty.model.NetworkConnectionAction.wrap(buildAwsValue())
}
object NetworkConnectionAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.NetworkConnectionAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.NetworkConnectionAction =
      zio.aws.guardduty.model.NetworkConnectionAction(
        blocked.map(value => value),
        connectionDirection.map(value => value),
        localPortDetails.map(value => value.asEditable),
        protocol.map(value => value),
        localIpDetails.map(value => value.asEditable),
        remoteIpDetails.map(value => value.asEditable),
        remotePortDetails.map(value => value.asEditable)
      )
    def blocked: Optional[Boolean]
    def connectionDirection: Optional[String]
    def localPortDetails
        : Optional[zio.aws.guardduty.model.LocalPortDetails.ReadOnly]
    def protocol: Optional[String]
    def localIpDetails
        : Optional[zio.aws.guardduty.model.LocalIpDetails.ReadOnly]
    def remoteIpDetails
        : Optional[zio.aws.guardduty.model.RemoteIpDetails.ReadOnly]
    def remotePortDetails
        : Optional[zio.aws.guardduty.model.RemotePortDetails.ReadOnly]
    def getBlocked: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blocked", blocked)
    def getConnectionDirection: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionDirection", connectionDirection)
    def getLocalPortDetails: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.LocalPortDetails.ReadOnly
    ] = AwsError.unwrapOptionField("localPortDetails", localPortDetails)
    def getProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getLocalIpDetails
        : ZIO[Any, AwsError, zio.aws.guardduty.model.LocalIpDetails.ReadOnly] =
      AwsError.unwrapOptionField("localIpDetails", localIpDetails)
    def getRemoteIpDetails
        : ZIO[Any, AwsError, zio.aws.guardduty.model.RemoteIpDetails.ReadOnly] =
      AwsError.unwrapOptionField("remoteIpDetails", remoteIpDetails)
    def getRemotePortDetails: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.RemotePortDetails.ReadOnly
    ] = AwsError.unwrapOptionField("remotePortDetails", remotePortDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.NetworkConnectionAction
  ) extends zio.aws.guardduty.model.NetworkConnectionAction.ReadOnly {
    override val blocked: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.blocked())
      .map(value => value: Boolean)
    override val connectionDirection: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionDirection())
      .map(value => value: String)
    override val localPortDetails
        : Optional[zio.aws.guardduty.model.LocalPortDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localPortDetails())
        .map(value => zio.aws.guardduty.model.LocalPortDetails.wrap(value))
    override val protocol: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => value: String)
    override val localIpDetails
        : Optional[zio.aws.guardduty.model.LocalIpDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localIpDetails())
        .map(value => zio.aws.guardduty.model.LocalIpDetails.wrap(value))
    override val remoteIpDetails
        : Optional[zio.aws.guardduty.model.RemoteIpDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteIpDetails())
        .map(value => zio.aws.guardduty.model.RemoteIpDetails.wrap(value))
    override val remotePortDetails
        : Optional[zio.aws.guardduty.model.RemotePortDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remotePortDetails())
        .map(value => zio.aws.guardduty.model.RemotePortDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.NetworkConnectionAction
  ): zio.aws.guardduty.model.NetworkConnectionAction.ReadOnly = new Wrapper(
    impl
  )
}
