package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetworkInterface(
    ipv6Addresses: Optional[Iterable[String]] = Optional.Absent,
    networkInterfaceId: Optional[String] = Optional.Absent,
    privateDnsName: Optional[String] = Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent,
    privateIpAddresses: Optional[
      Iterable[zio.aws.guardduty.model.PrivateIpAddressDetails]
    ] = Optional.Absent,
    publicDnsName: Optional[String] = Optional.Absent,
    publicIp: Optional[String] = Optional.Absent,
    securityGroups: Optional[Iterable[zio.aws.guardduty.model.SecurityGroup]] =
      Optional.Absent,
    subnetId: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.NetworkInterface = {
    import NetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.NetworkInterface
      .builder()
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(publicDnsName.map(value => value: java.lang.String))(
        _.publicDnsName
      )
      .optionallyWith(publicIp.map(value => value: java.lang.String))(
        _.publicIp
      )
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.NetworkInterface.ReadOnly =
    zio.aws.guardduty.model.NetworkInterface.wrap(buildAwsValue())
}
object NetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.NetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.NetworkInterface =
      zio.aws.guardduty.model.NetworkInterface(
        ipv6Addresses.map(value => value),
        networkInterfaceId.map(value => value),
        privateDnsName.map(value => value),
        privateIpAddress.map(value => value),
        privateIpAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        publicDnsName.map(value => value),
        publicIp.map(value => value),
        securityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subnetId.map(value => value),
        vpcId.map(value => value)
      )
    def ipv6Addresses: Optional[List[String]]
    def networkInterfaceId: Optional[String]
    def privateDnsName: Optional[String]
    def privateIpAddress: Optional[String]
    def privateIpAddresses: Optional[
      List[zio.aws.guardduty.model.PrivateIpAddressDetails.ReadOnly]
    ]
    def publicDnsName: Optional[String]
    def publicIp: Optional[String]
    def securityGroups
        : Optional[List[zio.aws.guardduty.model.SecurityGroup.ReadOnly]]
    def subnetId: Optional[String]
    def vpcId: Optional[String]
    def getIpv6Addresses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.PrivateIpAddressDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getPublicDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicDnsName", publicDnsName)
    def getPublicIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.SecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.NetworkInterface
  ) extends zio.aws.guardduty.model.NetworkInterface.ReadOnly {
    override val ipv6Addresses: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Addresses())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
    override val privateDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsName())
      .map(value => value: String)
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
    override val privateIpAddresses: Optional[
      List[zio.aws.guardduty.model.PrivateIpAddressDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.guardduty.model.PrivateIpAddressDetails.wrap(item)
        }.toList
      )
    override val publicDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicDnsName())
      .map(value => value: String)
    override val publicIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIp())
      .map(value => value: String)
    override val securityGroups
        : Optional[List[zio.aws.guardduty.model.SecurityGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.SecurityGroup.wrap(item)
          }.toList
        )
    override val subnetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.NetworkInterface
  ): zio.aws.guardduty.model.NetworkInterface.ReadOnly = new Wrapper(impl)
}
