package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Organization(
    asn: Optional[String] = Optional.Absent,
    asnOrg: Optional[String] = Optional.Absent,
    isp: Optional[String] = Optional.Absent,
    org: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.Organization = {
    import Organization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Organization
      .builder()
      .optionallyWith(asn.map(value => value: java.lang.String))(_.asn)
      .optionallyWith(asnOrg.map(value => value: java.lang.String))(_.asnOrg)
      .optionallyWith(isp.map(value => value: java.lang.String))(_.isp)
      .optionallyWith(org.map(value => value: java.lang.String))(_.org)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Organization.ReadOnly =
    zio.aws.guardduty.model.Organization.wrap(buildAwsValue())
}
object Organization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.Organization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Organization =
      zio.aws.guardduty.model.Organization(
        asn.map(value => value),
        asnOrg.map(value => value),
        isp.map(value => value),
        org.map(value => value)
      )
    def asn: Optional[String]
    def asnOrg: Optional[String]
    def isp: Optional[String]
    def org: Optional[String]
    def getAsn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("asn", asn)
    def getAsnOrg: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("asnOrg", asnOrg)
    def getIsp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("isp", isp)
    def getOrg: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("org", org)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Organization
  ) extends zio.aws.guardduty.model.Organization.ReadOnly {
    override val asn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.asn())
      .map(value => value: String)
    override val asnOrg: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.asnOrg())
      .map(value => value: String)
    override val isp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.isp())
      .map(value => value: String)
    override val org: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.org())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Organization
  ): zio.aws.guardduty.model.Organization.ReadOnly = new Wrapper(impl)
}
