package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OrganizationDataSourceConfigurations(
    s3Logs: Optional[zio.aws.guardduty.model.OrganizationS3LogsConfiguration] =
      Optional.Absent,
    kubernetes: Optional[
      zio.aws.guardduty.model.OrganizationKubernetesConfiguration
    ] = Optional.Absent,
    malwareProtection: Optional[
      zio.aws.guardduty.model.OrganizationMalwareProtectionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.OrganizationDataSourceConfigurations = {
    import OrganizationDataSourceConfigurations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.OrganizationDataSourceConfigurations
      .builder()
      .optionallyWith(s3Logs.map(value => value.buildAwsValue()))(_.s3Logs)
      .optionallyWith(kubernetes.map(value => value.buildAwsValue()))(
        _.kubernetes
      )
      .optionallyWith(malwareProtection.map(value => value.buildAwsValue()))(
        _.malwareProtection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.OrganizationDataSourceConfigurations.ReadOnly =
    zio.aws.guardduty.model.OrganizationDataSourceConfigurations
      .wrap(buildAwsValue())
}
object OrganizationDataSourceConfigurations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.OrganizationDataSourceConfigurations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.OrganizationDataSourceConfigurations =
      zio.aws.guardduty.model.OrganizationDataSourceConfigurations(
        s3Logs.map(value => value.asEditable),
        kubernetes.map(value => value.asEditable),
        malwareProtection.map(value => value.asEditable)
      )
    def s3Logs: Optional[
      zio.aws.guardduty.model.OrganizationS3LogsConfiguration.ReadOnly
    ]
    def kubernetes: Optional[
      zio.aws.guardduty.model.OrganizationKubernetesConfiguration.ReadOnly
    ]
    def malwareProtection: Optional[
      zio.aws.guardduty.model.OrganizationMalwareProtectionConfiguration.ReadOnly
    ]
    def getS3Logs: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.OrganizationS3LogsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3Logs", s3Logs)
    def getKubernetes: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.OrganizationKubernetesConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("kubernetes", kubernetes)
    def getMalwareProtection: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.OrganizationMalwareProtectionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("malwareProtection", malwareProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationDataSourceConfigurations
  ) extends zio.aws.guardduty.model.OrganizationDataSourceConfigurations.ReadOnly {
    override val s3Logs: Optional[
      zio.aws.guardduty.model.OrganizationS3LogsConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Logs())
      .map(value =>
        zio.aws.guardduty.model.OrganizationS3LogsConfiguration.wrap(value)
      )
    override val kubernetes: Optional[
      zio.aws.guardduty.model.OrganizationKubernetesConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kubernetes())
      .map(value =>
        zio.aws.guardduty.model.OrganizationKubernetesConfiguration.wrap(value)
      )
    override val malwareProtection: Optional[
      zio.aws.guardduty.model.OrganizationMalwareProtectionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.malwareProtection())
      .map(value =>
        zio.aws.guardduty.model.OrganizationMalwareProtectionConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationDataSourceConfigurations
  ): zio.aws.guardduty.model.OrganizationDataSourceConfigurations.ReadOnly =
    new Wrapper(impl)
}
