package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OrganizationDataSourceConfigurationsResult(
    s3Logs: zio.aws.guardduty.model.OrganizationS3LogsConfigurationResult,
    kubernetes: Optional[
      zio.aws.guardduty.model.OrganizationKubernetesConfigurationResult
    ] = Optional.Absent,
    malwareProtection: Optional[
      zio.aws.guardduty.model.OrganizationMalwareProtectionConfigurationResult
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.OrganizationDataSourceConfigurationsResult = {
    import OrganizationDataSourceConfigurationsResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.OrganizationDataSourceConfigurationsResult
      .builder()
      .s3Logs(s3Logs.buildAwsValue())
      .optionallyWith(kubernetes.map(value => value.buildAwsValue()))(
        _.kubernetes
      )
      .optionallyWith(malwareProtection.map(value => value.buildAwsValue()))(
        _.malwareProtection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.OrganizationDataSourceConfigurationsResult.ReadOnly =
    zio.aws.guardduty.model.OrganizationDataSourceConfigurationsResult
      .wrap(buildAwsValue())
}
object OrganizationDataSourceConfigurationsResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.OrganizationDataSourceConfigurationsResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.OrganizationDataSourceConfigurationsResult =
      zio.aws.guardduty.model.OrganizationDataSourceConfigurationsResult(
        s3Logs.asEditable,
        kubernetes.map(value => value.asEditable),
        malwareProtection.map(value => value.asEditable)
      )
    def s3Logs
        : zio.aws.guardduty.model.OrganizationS3LogsConfigurationResult.ReadOnly
    def kubernetes: Optional[
      zio.aws.guardduty.model.OrganizationKubernetesConfigurationResult.ReadOnly
    ]
    def malwareProtection: Optional[
      zio.aws.guardduty.model.OrganizationMalwareProtectionConfigurationResult.ReadOnly
    ]
    def getS3Logs: ZIO[
      Any,
      Nothing,
      zio.aws.guardduty.model.OrganizationS3LogsConfigurationResult.ReadOnly
    ] = ZIO.succeed(s3Logs)
    def getKubernetes: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.OrganizationKubernetesConfigurationResult.ReadOnly
    ] = AwsError.unwrapOptionField("kubernetes", kubernetes)
    def getMalwareProtection: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.OrganizationMalwareProtectionConfigurationResult.ReadOnly
    ] = AwsError.unwrapOptionField("malwareProtection", malwareProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationDataSourceConfigurationsResult
  ) extends zio.aws.guardduty.model.OrganizationDataSourceConfigurationsResult.ReadOnly {
    override val s3Logs
        : zio.aws.guardduty.model.OrganizationS3LogsConfigurationResult.ReadOnly =
      zio.aws.guardduty.model.OrganizationS3LogsConfigurationResult
        .wrap(impl.s3Logs())
    override val kubernetes: Optional[
      zio.aws.guardduty.model.OrganizationKubernetesConfigurationResult.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kubernetes())
      .map(value =>
        zio.aws.guardduty.model.OrganizationKubernetesConfigurationResult
          .wrap(value)
      )
    override val malwareProtection: Optional[
      zio.aws.guardduty.model.OrganizationMalwareProtectionConfigurationResult.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.malwareProtection())
      .map(value =>
        zio.aws.guardduty.model.OrganizationMalwareProtectionConfigurationResult
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationDataSourceConfigurationsResult
  ): zio.aws.guardduty.model.OrganizationDataSourceConfigurationsResult.ReadOnly =
    new Wrapper(impl)
}
