package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OrganizationEbsVolumes(
    autoEnable: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.OrganizationEbsVolumes = {
    import OrganizationEbsVolumes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.OrganizationEbsVolumes
      .builder()
      .optionallyWith(autoEnable.map(value => value: java.lang.Boolean))(
        _.autoEnable
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.OrganizationEbsVolumes.ReadOnly =
    zio.aws.guardduty.model.OrganizationEbsVolumes.wrap(buildAwsValue())
}
object OrganizationEbsVolumes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.OrganizationEbsVolumes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.OrganizationEbsVolumes =
      zio.aws.guardduty.model
        .OrganizationEbsVolumes(autoEnable.map(value => value))
    def autoEnable: Optional[Boolean]
    def getAutoEnable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoEnable", autoEnable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationEbsVolumes
  ) extends zio.aws.guardduty.model.OrganizationEbsVolumes.ReadOnly {
    override val autoEnable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoEnable())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationEbsVolumes
  ): zio.aws.guardduty.model.OrganizationEbsVolumes.ReadOnly = new Wrapper(impl)
}
