package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OrganizationEbsVolumesResult(
    autoEnable: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.OrganizationEbsVolumesResult = {
    import OrganizationEbsVolumesResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.OrganizationEbsVolumesResult
      .builder()
      .optionallyWith(autoEnable.map(value => value: java.lang.Boolean))(
        _.autoEnable
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.OrganizationEbsVolumesResult.ReadOnly =
    zio.aws.guardduty.model.OrganizationEbsVolumesResult.wrap(buildAwsValue())
}
object OrganizationEbsVolumesResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.OrganizationEbsVolumesResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.OrganizationEbsVolumesResult =
      zio.aws.guardduty.model
        .OrganizationEbsVolumesResult(autoEnable.map(value => value))
    def autoEnable: Optional[Boolean]
    def getAutoEnable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoEnable", autoEnable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationEbsVolumesResult
  ) extends zio.aws.guardduty.model.OrganizationEbsVolumesResult.ReadOnly {
    override val autoEnable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoEnable())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationEbsVolumesResult
  ): zio.aws.guardduty.model.OrganizationEbsVolumesResult.ReadOnly =
    new Wrapper(impl)
}
