package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OrganizationKubernetesConfigurationResult(
    auditLogs: zio.aws.guardduty.model.OrganizationKubernetesAuditLogsConfigurationResult
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.OrganizationKubernetesConfigurationResult = {
    import OrganizationKubernetesConfigurationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.OrganizationKubernetesConfigurationResult
      .builder()
      .auditLogs(auditLogs.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.OrganizationKubernetesConfigurationResult.ReadOnly =
    zio.aws.guardduty.model.OrganizationKubernetesConfigurationResult
      .wrap(buildAwsValue())
}
object OrganizationKubernetesConfigurationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.OrganizationKubernetesConfigurationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.OrganizationKubernetesConfigurationResult =
      zio.aws.guardduty.model
        .OrganizationKubernetesConfigurationResult(auditLogs.asEditable)
    def auditLogs
        : zio.aws.guardduty.model.OrganizationKubernetesAuditLogsConfigurationResult.ReadOnly
    def getAuditLogs: ZIO[
      Any,
      Nothing,
      zio.aws.guardduty.model.OrganizationKubernetesAuditLogsConfigurationResult.ReadOnly
    ] = ZIO.succeed(auditLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationKubernetesConfigurationResult
  ) extends zio.aws.guardduty.model.OrganizationKubernetesConfigurationResult.ReadOnly {
    override val auditLogs
        : zio.aws.guardduty.model.OrganizationKubernetesAuditLogsConfigurationResult.ReadOnly =
      zio.aws.guardduty.model.OrganizationKubernetesAuditLogsConfigurationResult
        .wrap(impl.auditLogs())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationKubernetesConfigurationResult
  ): zio.aws.guardduty.model.OrganizationKubernetesConfigurationResult.ReadOnly =
    new Wrapper(impl)
}
