package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OrganizationMalwareProtectionConfiguration(
    scanEc2InstanceWithFindings: Optional[
      zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.OrganizationMalwareProtectionConfiguration = {
    import OrganizationMalwareProtectionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.OrganizationMalwareProtectionConfiguration
      .builder()
      .optionallyWith(
        scanEc2InstanceWithFindings.map(value => value.buildAwsValue())
      )(_.scanEc2InstanceWithFindings)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.OrganizationMalwareProtectionConfiguration.ReadOnly =
    zio.aws.guardduty.model.OrganizationMalwareProtectionConfiguration
      .wrap(buildAwsValue())
}
object OrganizationMalwareProtectionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.OrganizationMalwareProtectionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.OrganizationMalwareProtectionConfiguration =
      zio.aws.guardduty.model.OrganizationMalwareProtectionConfiguration(
        scanEc2InstanceWithFindings.map(value => value.asEditable)
      )
    def scanEc2InstanceWithFindings: Optional[
      zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindings.ReadOnly
    ]
    def getScanEc2InstanceWithFindings: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scanEc2InstanceWithFindings",
      scanEc2InstanceWithFindings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationMalwareProtectionConfiguration
  ) extends zio.aws.guardduty.model.OrganizationMalwareProtectionConfiguration.ReadOnly {
    override val scanEc2InstanceWithFindings: Optional[
      zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scanEc2InstanceWithFindings())
      .map(value =>
        zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindings
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationMalwareProtectionConfiguration
  ): zio.aws.guardduty.model.OrganizationMalwareProtectionConfiguration.ReadOnly =
    new Wrapper(impl)
}
