package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OrganizationMalwareProtectionConfigurationResult(
    scanEc2InstanceWithFindings: Optional[
      zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.OrganizationMalwareProtectionConfigurationResult = {
    import OrganizationMalwareProtectionConfigurationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.OrganizationMalwareProtectionConfigurationResult
      .builder()
      .optionallyWith(
        scanEc2InstanceWithFindings.map(value => value.buildAwsValue())
      )(_.scanEc2InstanceWithFindings)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.OrganizationMalwareProtectionConfigurationResult.ReadOnly =
    zio.aws.guardduty.model.OrganizationMalwareProtectionConfigurationResult
      .wrap(buildAwsValue())
}
object OrganizationMalwareProtectionConfigurationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.OrganizationMalwareProtectionConfigurationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.OrganizationMalwareProtectionConfigurationResult =
      zio.aws.guardduty.model.OrganizationMalwareProtectionConfigurationResult(
        scanEc2InstanceWithFindings.map(value => value.asEditable)
      )
    def scanEc2InstanceWithFindings: Optional[
      zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult.ReadOnly
    ]
    def getScanEc2InstanceWithFindings: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scanEc2InstanceWithFindings",
      scanEc2InstanceWithFindings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationMalwareProtectionConfigurationResult
  ) extends zio.aws.guardduty.model.OrganizationMalwareProtectionConfigurationResult.ReadOnly {
    override val scanEc2InstanceWithFindings: Optional[
      zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scanEc2InstanceWithFindings())
      .map(value =>
        zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationMalwareProtectionConfigurationResult
  ): zio.aws.guardduty.model.OrganizationMalwareProtectionConfigurationResult.ReadOnly =
    new Wrapper(impl)
}
