package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OrganizationScanEc2InstanceWithFindings(
    ebsVolumes: Optional[zio.aws.guardduty.model.OrganizationEbsVolumes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.OrganizationScanEc2InstanceWithFindings = {
    import OrganizationScanEc2InstanceWithFindings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.OrganizationScanEc2InstanceWithFindings
      .builder()
      .optionallyWith(ebsVolumes.map(value => value.buildAwsValue()))(
        _.ebsVolumes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindings.ReadOnly =
    zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindings
      .wrap(buildAwsValue())
}
object OrganizationScanEc2InstanceWithFindings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.OrganizationScanEc2InstanceWithFindings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindings =
      zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindings(
        ebsVolumes.map(value => value.asEditable)
      )
    def ebsVolumes
        : Optional[zio.aws.guardduty.model.OrganizationEbsVolumes.ReadOnly]
    def getEbsVolumes: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.OrganizationEbsVolumes.ReadOnly
    ] = AwsError.unwrapOptionField("ebsVolumes", ebsVolumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationScanEc2InstanceWithFindings
  ) extends zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindings.ReadOnly {
    override val ebsVolumes
        : Optional[zio.aws.guardduty.model.OrganizationEbsVolumes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsVolumes())
        .map(value =>
          zio.aws.guardduty.model.OrganizationEbsVolumes.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationScanEc2InstanceWithFindings
  ): zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindings.ReadOnly =
    new Wrapper(impl)
}
