package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OrganizationScanEc2InstanceWithFindingsResult(
    ebsVolumes: Optional[zio.aws.guardduty.model.OrganizationEbsVolumesResult] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult = {
    import OrganizationScanEc2InstanceWithFindingsResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult
      .builder()
      .optionallyWith(ebsVolumes.map(value => value.buildAwsValue()))(
        _.ebsVolumes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult.ReadOnly =
    zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult
      .wrap(buildAwsValue())
}
object OrganizationScanEc2InstanceWithFindingsResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult =
      zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult(
        ebsVolumes.map(value => value.asEditable)
      )
    def ebsVolumes: Optional[
      zio.aws.guardduty.model.OrganizationEbsVolumesResult.ReadOnly
    ]
    def getEbsVolumes: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.OrganizationEbsVolumesResult.ReadOnly
    ] = AwsError.unwrapOptionField("ebsVolumes", ebsVolumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult
  ) extends zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult.ReadOnly {
    override val ebsVolumes: Optional[
      zio.aws.guardduty.model.OrganizationEbsVolumesResult.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsVolumes())
      .map(value =>
        zio.aws.guardduty.model.OrganizationEbsVolumesResult.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult
  ): zio.aws.guardduty.model.OrganizationScanEc2InstanceWithFindingsResult.ReadOnly =
    new Wrapper(impl)
}
