package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Owner(id: Optional[String] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.guardduty.model.Owner = {
    import Owner.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Owner
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Owner.ReadOnly =
    zio.aws.guardduty.model.Owner.wrap(buildAwsValue())
}
object Owner {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.guardduty.model.Owner] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Owner =
      zio.aws.guardduty.model.Owner(id.map(value => value))
    def id: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Owner
  ) extends zio.aws.guardduty.model.Owner.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Owner
  ): zio.aws.guardduty.model.Owner.ReadOnly = new Wrapper(impl)
}
