package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PermissionConfiguration(
    bucketLevelPermissions: Optional[
      zio.aws.guardduty.model.BucketLevelPermissions
    ] = Optional.Absent,
    accountLevelPermissions: Optional[
      zio.aws.guardduty.model.AccountLevelPermissions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.PermissionConfiguration = {
    import PermissionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.PermissionConfiguration
      .builder()
      .optionallyWith(
        bucketLevelPermissions.map(value => value.buildAwsValue())
      )(_.bucketLevelPermissions)
      .optionallyWith(
        accountLevelPermissions.map(value => value.buildAwsValue())
      )(_.accountLevelPermissions)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.PermissionConfiguration.ReadOnly =
    zio.aws.guardduty.model.PermissionConfiguration.wrap(buildAwsValue())
}
object PermissionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.PermissionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.PermissionConfiguration =
      zio.aws.guardduty.model.PermissionConfiguration(
        bucketLevelPermissions.map(value => value.asEditable),
        accountLevelPermissions.map(value => value.asEditable)
      )
    def bucketLevelPermissions
        : Optional[zio.aws.guardduty.model.BucketLevelPermissions.ReadOnly]
    def accountLevelPermissions
        : Optional[zio.aws.guardduty.model.AccountLevelPermissions.ReadOnly]
    def getBucketLevelPermissions: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.BucketLevelPermissions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketLevelPermissions",
      bucketLevelPermissions
    )
    def getAccountLevelPermissions: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.AccountLevelPermissions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accountLevelPermissions",
      accountLevelPermissions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.PermissionConfiguration
  ) extends zio.aws.guardduty.model.PermissionConfiguration.ReadOnly {
    override val bucketLevelPermissions
        : Optional[zio.aws.guardduty.model.BucketLevelPermissions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketLevelPermissions())
        .map(value =>
          zio.aws.guardduty.model.BucketLevelPermissions.wrap(value)
        )
    override val accountLevelPermissions
        : Optional[zio.aws.guardduty.model.AccountLevelPermissions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountLevelPermissions())
        .map(value =>
          zio.aws.guardduty.model.AccountLevelPermissions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.PermissionConfiguration
  ): zio.aws.guardduty.model.PermissionConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
