package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PortProbeAction(
    blocked: Optional[Boolean] = Optional.Absent,
    portProbeDetails: Optional[
      Iterable[zio.aws.guardduty.model.PortProbeDetail]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.PortProbeAction = {
    import PortProbeAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.PortProbeAction
      .builder()
      .optionallyWith(blocked.map(value => value: java.lang.Boolean))(_.blocked)
      .optionallyWith(
        portProbeDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portProbeDetails)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.PortProbeAction.ReadOnly =
    zio.aws.guardduty.model.PortProbeAction.wrap(buildAwsValue())
}
object PortProbeAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.PortProbeAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.PortProbeAction =
      zio.aws.guardduty.model.PortProbeAction(
        blocked.map(value => value),
        portProbeDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def blocked: Optional[Boolean]
    def portProbeDetails
        : Optional[List[zio.aws.guardduty.model.PortProbeDetail.ReadOnly]]
    def getBlocked: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blocked", blocked)
    def getPortProbeDetails: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.PortProbeDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("portProbeDetails", portProbeDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.PortProbeAction
  ) extends zio.aws.guardduty.model.PortProbeAction.ReadOnly {
    override val blocked: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.blocked())
      .map(value => value: Boolean)
    override val portProbeDetails
        : Optional[List[zio.aws.guardduty.model.PortProbeDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portProbeDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.PortProbeDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.PortProbeAction
  ): zio.aws.guardduty.model.PortProbeAction.ReadOnly = new Wrapper(impl)
}
