package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PortProbeDetail(
    localPortDetails: Optional[zio.aws.guardduty.model.LocalPortDetails] =
      Optional.Absent,
    localIpDetails: Optional[zio.aws.guardduty.model.LocalIpDetails] =
      Optional.Absent,
    remoteIpDetails: Optional[zio.aws.guardduty.model.RemoteIpDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.PortProbeDetail = {
    import PortProbeDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.PortProbeDetail
      .builder()
      .optionallyWith(localPortDetails.map(value => value.buildAwsValue()))(
        _.localPortDetails
      )
      .optionallyWith(localIpDetails.map(value => value.buildAwsValue()))(
        _.localIpDetails
      )
      .optionallyWith(remoteIpDetails.map(value => value.buildAwsValue()))(
        _.remoteIpDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.PortProbeDetail.ReadOnly =
    zio.aws.guardduty.model.PortProbeDetail.wrap(buildAwsValue())
}
object PortProbeDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.PortProbeDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.PortProbeDetail =
      zio.aws.guardduty.model.PortProbeDetail(
        localPortDetails.map(value => value.asEditable),
        localIpDetails.map(value => value.asEditable),
        remoteIpDetails.map(value => value.asEditable)
      )
    def localPortDetails
        : Optional[zio.aws.guardduty.model.LocalPortDetails.ReadOnly]
    def localIpDetails
        : Optional[zio.aws.guardduty.model.LocalIpDetails.ReadOnly]
    def remoteIpDetails
        : Optional[zio.aws.guardduty.model.RemoteIpDetails.ReadOnly]
    def getLocalPortDetails: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.LocalPortDetails.ReadOnly
    ] = AwsError.unwrapOptionField("localPortDetails", localPortDetails)
    def getLocalIpDetails
        : ZIO[Any, AwsError, zio.aws.guardduty.model.LocalIpDetails.ReadOnly] =
      AwsError.unwrapOptionField("localIpDetails", localIpDetails)
    def getRemoteIpDetails
        : ZIO[Any, AwsError, zio.aws.guardduty.model.RemoteIpDetails.ReadOnly] =
      AwsError.unwrapOptionField("remoteIpDetails", remoteIpDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.PortProbeDetail
  ) extends zio.aws.guardduty.model.PortProbeDetail.ReadOnly {
    override val localPortDetails
        : Optional[zio.aws.guardduty.model.LocalPortDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localPortDetails())
        .map(value => zio.aws.guardduty.model.LocalPortDetails.wrap(value))
    override val localIpDetails
        : Optional[zio.aws.guardduty.model.LocalIpDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localIpDetails())
        .map(value => zio.aws.guardduty.model.LocalIpDetails.wrap(value))
    override val remoteIpDetails
        : Optional[zio.aws.guardduty.model.RemoteIpDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteIpDetails())
        .map(value => zio.aws.guardduty.model.RemoteIpDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.PortProbeDetail
  ): zio.aws.guardduty.model.PortProbeDetail.ReadOnly = new Wrapper(impl)
}
