package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PrivateIpAddressDetails(
    privateDnsName: Optional[String] = Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.PrivateIpAddressDetails = {
    import PrivateIpAddressDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.PrivateIpAddressDetails
      .builder()
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.PrivateIpAddressDetails.ReadOnly =
    zio.aws.guardduty.model.PrivateIpAddressDetails.wrap(buildAwsValue())
}
object PrivateIpAddressDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.PrivateIpAddressDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.PrivateIpAddressDetails =
      zio.aws.guardduty.model.PrivateIpAddressDetails(
        privateDnsName.map(value => value),
        privateIpAddress.map(value => value)
      )
    def privateDnsName: Optional[String]
    def privateIpAddress: Optional[String]
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.PrivateIpAddressDetails
  ) extends zio.aws.guardduty.model.PrivateIpAddressDetails.ReadOnly {
    override val privateDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsName())
      .map(value => value: String)
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.PrivateIpAddressDetails
  ): zio.aws.guardduty.model.PrivateIpAddressDetails.ReadOnly = new Wrapper(
    impl
  )
}
