package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProductCode(
    code: Optional[String] = Optional.Absent,
    productType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ProductCode = {
    import ProductCode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ProductCode
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(productType.map(value => value: java.lang.String))(
        _.productType
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ProductCode.ReadOnly =
    zio.aws.guardduty.model.ProductCode.wrap(buildAwsValue())
}
object ProductCode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ProductCode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ProductCode =
      zio.aws.guardduty.model
        .ProductCode(code.map(value => value), productType.map(value => value))
    def code: Optional[String]
    def productType: Optional[String]
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getProductType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productType", productType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ProductCode
  ) extends zio.aws.guardduty.model.ProductCode.ReadOnly {
    override val code: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: String)
    override val productType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.productType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ProductCode
  ): zio.aws.guardduty.model.ProductCode.ReadOnly = new Wrapper(impl)
}
