package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PublicAccess(
    permissionConfiguration: Optional[
      zio.aws.guardduty.model.PermissionConfiguration
    ] = Optional.Absent,
    effectivePermission: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.PublicAccess = {
    import PublicAccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.PublicAccess
      .builder()
      .optionallyWith(
        permissionConfiguration.map(value => value.buildAwsValue())
      )(_.permissionConfiguration)
      .optionallyWith(
        effectivePermission.map(value => value: java.lang.String)
      )(_.effectivePermission)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.PublicAccess.ReadOnly =
    zio.aws.guardduty.model.PublicAccess.wrap(buildAwsValue())
}
object PublicAccess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.PublicAccess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.PublicAccess =
      zio.aws.guardduty.model.PublicAccess(
        permissionConfiguration.map(value => value.asEditable),
        effectivePermission.map(value => value)
      )
    def permissionConfiguration
        : Optional[zio.aws.guardduty.model.PermissionConfiguration.ReadOnly]
    def effectivePermission: Optional[String]
    def getPermissionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.PermissionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "permissionConfiguration",
      permissionConfiguration
    )
    def getEffectivePermission: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("effectivePermission", effectivePermission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.PublicAccess
  ) extends zio.aws.guardduty.model.PublicAccess.ReadOnly {
    override val permissionConfiguration
        : Optional[zio.aws.guardduty.model.PermissionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionConfiguration())
        .map(value =>
          zio.aws.guardduty.model.PermissionConfiguration.wrap(value)
        )
    override val effectivePermission: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.effectivePermission())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.PublicAccess
  ): zio.aws.guardduty.model.PublicAccess.ReadOnly = new Wrapper(impl)
}
