package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait PublishingStatus {
  def unwrap: software.amazon.awssdk.services.guardduty.model.PublishingStatus
}
object PublishingStatus {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.PublishingStatus
  ): zio.aws.guardduty.model.PublishingStatus = value match {
    case software.amazon.awssdk.services.guardduty.model.PublishingStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.PublishingStatus.PENDING_VERIFICATION =>
      val r = PENDING_VERIFICATION
      r
    case software.amazon.awssdk.services.guardduty.model.PublishingStatus.PUBLISHING =>
      val r = PUBLISHING
      r
    case software.amazon.awssdk.services.guardduty.model.PublishingStatus.UNABLE_TO_PUBLISH_FIX_DESTINATION_PROPERTY =>
      val r = UNABLE_TO_PUBLISH_FIX_DESTINATION_PROPERTY
      r
    case software.amazon.awssdk.services.guardduty.model.PublishingStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.guardduty.model.PublishingStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.PublishingStatus =
      software.amazon.awssdk.services.guardduty.model.PublishingStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_VERIFICATION
      extends zio.aws.guardduty.model.PublishingStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.PublishingStatus =
      software.amazon.awssdk.services.guardduty.model.PublishingStatus.PENDING_VERIFICATION
  }
  case object PUBLISHING extends zio.aws.guardduty.model.PublishingStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.PublishingStatus =
      software.amazon.awssdk.services.guardduty.model.PublishingStatus.PUBLISHING
  }
  case object UNABLE_TO_PUBLISH_FIX_DESTINATION_PROPERTY
      extends zio.aws.guardduty.model.PublishingStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.PublishingStatus =
      software.amazon.awssdk.services.guardduty.model.PublishingStatus.UNABLE_TO_PUBLISH_FIX_DESTINATION_PROPERTY
  }
  case object STOPPED extends zio.aws.guardduty.model.PublishingStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.PublishingStatus =
      software.amazon.awssdk.services.guardduty.model.PublishingStatus.STOPPED
  }
}
