package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RemoteAccountDetails(
    accountId: Optional[String] = Optional.Absent,
    affiliated: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.RemoteAccountDetails = {
    import RemoteAccountDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.RemoteAccountDetails
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(affiliated.map(value => value: java.lang.Boolean))(
        _.affiliated
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.RemoteAccountDetails.ReadOnly =
    zio.aws.guardduty.model.RemoteAccountDetails.wrap(buildAwsValue())
}
object RemoteAccountDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.RemoteAccountDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.RemoteAccountDetails =
      zio.aws.guardduty.model.RemoteAccountDetails(
        accountId.map(value => value),
        affiliated.map(value => value)
      )
    def accountId: Optional[String]
    def affiliated: Optional[Boolean]
    def getAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAffiliated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("affiliated", affiliated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.RemoteAccountDetails
  ) extends zio.aws.guardduty.model.RemoteAccountDetails.ReadOnly {
    override val accountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: String)
    override val affiliated: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.affiliated())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.RemoteAccountDetails
  ): zio.aws.guardduty.model.RemoteAccountDetails.ReadOnly = new Wrapper(impl)
}
