package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RemoteIpDetails(
    city: Optional[zio.aws.guardduty.model.City] = Optional.Absent,
    country: Optional[zio.aws.guardduty.model.Country] = Optional.Absent,
    geoLocation: Optional[zio.aws.guardduty.model.GeoLocation] =
      Optional.Absent,
    ipAddressV4: Optional[String] = Optional.Absent,
    organization: Optional[zio.aws.guardduty.model.Organization] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.RemoteIpDetails = {
    import RemoteIpDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.RemoteIpDetails
      .builder()
      .optionallyWith(city.map(value => value.buildAwsValue()))(_.city)
      .optionallyWith(country.map(value => value.buildAwsValue()))(_.country)
      .optionallyWith(geoLocation.map(value => value.buildAwsValue()))(
        _.geoLocation
      )
      .optionallyWith(ipAddressV4.map(value => value: java.lang.String))(
        _.ipAddressV4
      )
      .optionallyWith(organization.map(value => value.buildAwsValue()))(
        _.organization
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.RemoteIpDetails.ReadOnly =
    zio.aws.guardduty.model.RemoteIpDetails.wrap(buildAwsValue())
}
object RemoteIpDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.RemoteIpDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.RemoteIpDetails =
      zio.aws.guardduty.model.RemoteIpDetails(
        city.map(value => value.asEditable),
        country.map(value => value.asEditable),
        geoLocation.map(value => value.asEditable),
        ipAddressV4.map(value => value),
        organization.map(value => value.asEditable)
      )
    def city: Optional[zio.aws.guardduty.model.City.ReadOnly]
    def country: Optional[zio.aws.guardduty.model.Country.ReadOnly]
    def geoLocation: Optional[zio.aws.guardduty.model.GeoLocation.ReadOnly]
    def ipAddressV4: Optional[String]
    def organization: Optional[zio.aws.guardduty.model.Organization.ReadOnly]
    def getCity: ZIO[Any, AwsError, zio.aws.guardduty.model.City.ReadOnly] =
      AwsError.unwrapOptionField("city", city)
    def getCountry
        : ZIO[Any, AwsError, zio.aws.guardduty.model.Country.ReadOnly] =
      AwsError.unwrapOptionField("country", country)
    def getGeoLocation
        : ZIO[Any, AwsError, zio.aws.guardduty.model.GeoLocation.ReadOnly] =
      AwsError.unwrapOptionField("geoLocation", geoLocation)
    def getIpAddressV4: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipAddressV4", ipAddressV4)
    def getOrganization
        : ZIO[Any, AwsError, zio.aws.guardduty.model.Organization.ReadOnly] =
      AwsError.unwrapOptionField("organization", organization)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.RemoteIpDetails
  ) extends zio.aws.guardduty.model.RemoteIpDetails.ReadOnly {
    override val city: Optional[zio.aws.guardduty.model.City.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.city())
        .map(value => zio.aws.guardduty.model.City.wrap(value))
    override val country: Optional[zio.aws.guardduty.model.Country.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.country())
        .map(value => zio.aws.guardduty.model.Country.wrap(value))
    override val geoLocation
        : Optional[zio.aws.guardduty.model.GeoLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geoLocation())
        .map(value => zio.aws.guardduty.model.GeoLocation.wrap(value))
    override val ipAddressV4: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddressV4())
      .map(value => value: String)
    override val organization
        : Optional[zio.aws.guardduty.model.Organization.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organization())
        .map(value => zio.aws.guardduty.model.Organization.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.RemoteIpDetails
  ): zio.aws.guardduty.model.RemoteIpDetails.ReadOnly = new Wrapper(impl)
}
