package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class RemotePortDetails(
    port: Optional[Integer] = Optional.Absent,
    portName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.RemotePortDetails = {
    import RemotePortDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.RemotePortDetails
      .builder()
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(portName.map(value => value: java.lang.String))(
        _.portName
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.RemotePortDetails.ReadOnly =
    zio.aws.guardduty.model.RemotePortDetails.wrap(buildAwsValue())
}
object RemotePortDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.RemotePortDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.RemotePortDetails =
      zio.aws.guardduty.model.RemotePortDetails(
        port.map(value => value),
        portName.map(value => value)
      )
    def port: Optional[Integer]
    def portName: Optional[String]
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getPortName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("portName", portName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.RemotePortDetails
  ) extends zio.aws.guardduty.model.RemotePortDetails.ReadOnly {
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val portName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.portName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.RemotePortDetails
  ): zio.aws.guardduty.model.RemotePortDetails.ReadOnly = new Wrapper(impl)
}
