package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Resource(
    accessKeyDetails: Optional[zio.aws.guardduty.model.AccessKeyDetails] =
      Optional.Absent,
    s3BucketDetails: Optional[
      Iterable[zio.aws.guardduty.model.S3BucketDetail]
    ] = Optional.Absent,
    instanceDetails: Optional[zio.aws.guardduty.model.InstanceDetails] =
      Optional.Absent,
    eksClusterDetails: Optional[zio.aws.guardduty.model.EksClusterDetails] =
      Optional.Absent,
    kubernetesDetails: Optional[zio.aws.guardduty.model.KubernetesDetails] =
      Optional.Absent,
    resourceType: Optional[String] = Optional.Absent,
    ebsVolumeDetails: Optional[zio.aws.guardduty.model.EbsVolumeDetails] =
      Optional.Absent,
    ecsClusterDetails: Optional[zio.aws.guardduty.model.EcsClusterDetails] =
      Optional.Absent,
    containerDetails: Optional[zio.aws.guardduty.model.Container] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Resource
      .builder()
      .optionallyWith(accessKeyDetails.map(value => value.buildAwsValue()))(
        _.accessKeyDetails
      )
      .optionallyWith(
        s3BucketDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.s3BucketDetails)
      .optionallyWith(instanceDetails.map(value => value.buildAwsValue()))(
        _.instanceDetails
      )
      .optionallyWith(eksClusterDetails.map(value => value.buildAwsValue()))(
        _.eksClusterDetails
      )
      .optionallyWith(kubernetesDetails.map(value => value.buildAwsValue()))(
        _.kubernetesDetails
      )
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .optionallyWith(ebsVolumeDetails.map(value => value.buildAwsValue()))(
        _.ebsVolumeDetails
      )
      .optionallyWith(ecsClusterDetails.map(value => value.buildAwsValue()))(
        _.ecsClusterDetails
      )
      .optionallyWith(containerDetails.map(value => value.buildAwsValue()))(
        _.containerDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Resource.ReadOnly =
    zio.aws.guardduty.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.Resource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Resource =
      zio.aws.guardduty.model.Resource(
        accessKeyDetails.map(value => value.asEditable),
        s3BucketDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceDetails.map(value => value.asEditable),
        eksClusterDetails.map(value => value.asEditable),
        kubernetesDetails.map(value => value.asEditable),
        resourceType.map(value => value),
        ebsVolumeDetails.map(value => value.asEditable),
        ecsClusterDetails.map(value => value.asEditable),
        containerDetails.map(value => value.asEditable)
      )
    def accessKeyDetails
        : Optional[zio.aws.guardduty.model.AccessKeyDetails.ReadOnly]
    def s3BucketDetails
        : Optional[List[zio.aws.guardduty.model.S3BucketDetail.ReadOnly]]
    def instanceDetails
        : Optional[zio.aws.guardduty.model.InstanceDetails.ReadOnly]
    def eksClusterDetails
        : Optional[zio.aws.guardduty.model.EksClusterDetails.ReadOnly]
    def kubernetesDetails
        : Optional[zio.aws.guardduty.model.KubernetesDetails.ReadOnly]
    def resourceType: Optional[String]
    def ebsVolumeDetails
        : Optional[zio.aws.guardduty.model.EbsVolumeDetails.ReadOnly]
    def ecsClusterDetails
        : Optional[zio.aws.guardduty.model.EcsClusterDetails.ReadOnly]
    def containerDetails: Optional[zio.aws.guardduty.model.Container.ReadOnly]
    def getAccessKeyDetails: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.AccessKeyDetails.ReadOnly
    ] = AwsError.unwrapOptionField("accessKeyDetails", accessKeyDetails)
    def getS3BucketDetails: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.S3BucketDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("s3BucketDetails", s3BucketDetails)
    def getInstanceDetails
        : ZIO[Any, AwsError, zio.aws.guardduty.model.InstanceDetails.ReadOnly] =
      AwsError.unwrapOptionField("instanceDetails", instanceDetails)
    def getEksClusterDetails: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.EksClusterDetails.ReadOnly
    ] = AwsError.unwrapOptionField("eksClusterDetails", eksClusterDetails)
    def getKubernetesDetails: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.KubernetesDetails.ReadOnly
    ] = AwsError.unwrapOptionField("kubernetesDetails", kubernetesDetails)
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getEbsVolumeDetails: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.EbsVolumeDetails.ReadOnly
    ] = AwsError.unwrapOptionField("ebsVolumeDetails", ebsVolumeDetails)
    def getEcsClusterDetails: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.EcsClusterDetails.ReadOnly
    ] = AwsError.unwrapOptionField("ecsClusterDetails", ecsClusterDetails)
    def getContainerDetails
        : ZIO[Any, AwsError, zio.aws.guardduty.model.Container.ReadOnly] =
      AwsError.unwrapOptionField("containerDetails", containerDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Resource
  ) extends zio.aws.guardduty.model.Resource.ReadOnly {
    override val accessKeyDetails
        : Optional[zio.aws.guardduty.model.AccessKeyDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessKeyDetails())
        .map(value => zio.aws.guardduty.model.AccessKeyDetails.wrap(value))
    override val s3BucketDetails
        : Optional[List[zio.aws.guardduty.model.S3BucketDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BucketDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.S3BucketDetail.wrap(item)
          }.toList
        )
    override val instanceDetails
        : Optional[zio.aws.guardduty.model.InstanceDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceDetails())
        .map(value => zio.aws.guardduty.model.InstanceDetails.wrap(value))
    override val eksClusterDetails
        : Optional[zio.aws.guardduty.model.EksClusterDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eksClusterDetails())
        .map(value => zio.aws.guardduty.model.EksClusterDetails.wrap(value))
    override val kubernetesDetails
        : Optional[zio.aws.guardduty.model.KubernetesDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kubernetesDetails())
        .map(value => zio.aws.guardduty.model.KubernetesDetails.wrap(value))
    override val resourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => value: String)
    override val ebsVolumeDetails
        : Optional[zio.aws.guardduty.model.EbsVolumeDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsVolumeDetails())
        .map(value => zio.aws.guardduty.model.EbsVolumeDetails.wrap(value))
    override val ecsClusterDetails
        : Optional[zio.aws.guardduty.model.EcsClusterDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecsClusterDetails())
        .map(value => zio.aws.guardduty.model.EcsClusterDetails.wrap(value))
    override val containerDetails
        : Optional[zio.aws.guardduty.model.Container.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerDetails())
        .map(value => zio.aws.guardduty.model.Container.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Resource
  ): zio.aws.guardduty.model.Resource.ReadOnly = new Wrapper(impl)
}
