package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.InstanceArn
import scala.jdk.CollectionConverters.*
final case class ResourceDetails(
    instanceArn: Optional[InstanceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ResourceDetails = {
    import ResourceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ResourceDetails
      .builder()
      .optionallyWith(
        instanceArn.map(value => InstanceArn.unwrap(value): java.lang.String)
      )(_.instanceArn)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ResourceDetails.ReadOnly =
    zio.aws.guardduty.model.ResourceDetails.wrap(buildAwsValue())
}
object ResourceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ResourceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ResourceDetails =
      zio.aws.guardduty.model.ResourceDetails(instanceArn.map(value => value))
    def instanceArn: Optional[InstanceArn]
    def getInstanceArn: ZIO[Any, AwsError, InstanceArn] =
      AwsError.unwrapOptionField("instanceArn", instanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ResourceDetails
  ) extends zio.aws.guardduty.model.ResourceDetails.ReadOnly {
    override val instanceArn: Optional[InstanceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceArn())
      .map(value => zio.aws.guardduty.model.primitives.InstanceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ResourceDetails
  ): zio.aws.guardduty.model.ResourceDetails.ReadOnly = new Wrapper(impl)
}
