package zio.aws.guardduty.model
import zio.aws.guardduty.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class S3BucketDetail(
    arn: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    owner: Optional[zio.aws.guardduty.model.Owner] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.guardduty.model.Tag]] = Optional.Absent,
    defaultServerSideEncryption: Optional[
      zio.aws.guardduty.model.DefaultServerSideEncryption
    ] = Optional.Absent,
    publicAccess: Optional[zio.aws.guardduty.model.PublicAccess] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.S3BucketDetail = {
    import S3BucketDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.S3BucketDetail
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        defaultServerSideEncryption.map(value => value.buildAwsValue())
      )(_.defaultServerSideEncryption)
      .optionallyWith(publicAccess.map(value => value.buildAwsValue()))(
        _.publicAccess
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.S3BucketDetail.ReadOnly =
    zio.aws.guardduty.model.S3BucketDetail.wrap(buildAwsValue())
}
object S3BucketDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.S3BucketDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.S3BucketDetail =
      zio.aws.guardduty.model.S3BucketDetail(
        arn.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        createdAt.map(value => value),
        owner.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        defaultServerSideEncryption.map(value => value.asEditable),
        publicAccess.map(value => value.asEditable)
      )
    def arn: Optional[String]
    def name: Optional[String]
    def `type`: Optional[String]
    def createdAt: Optional[Timestamp]
    def owner: Optional[zio.aws.guardduty.model.Owner.ReadOnly]
    def tags: Optional[List[zio.aws.guardduty.model.Tag.ReadOnly]]
    def defaultServerSideEncryption
        : Optional[zio.aws.guardduty.model.DefaultServerSideEncryption.ReadOnly]
    def publicAccess: Optional[zio.aws.guardduty.model.PublicAccess.ReadOnly]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getOwner: ZIO[Any, AwsError, zio.aws.guardduty.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.guardduty.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDefaultServerSideEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.DefaultServerSideEncryption.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultServerSideEncryption",
      defaultServerSideEncryption
    )
    def getPublicAccess
        : ZIO[Any, AwsError, zio.aws.guardduty.model.PublicAccess.ReadOnly] =
      AwsError.unwrapOptionField("publicAccess", publicAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.S3BucketDetail
  ) extends zio.aws.guardduty.model.S3BucketDetail.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.guardduty.model.primitives.Timestamp(value))
    override val owner: Optional[zio.aws.guardduty.model.Owner.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.guardduty.model.Owner.wrap(value))
    override val tags: Optional[List[zio.aws.guardduty.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.Tag.wrap(item)
          }.toList
        )
    override val defaultServerSideEncryption: Optional[
      zio.aws.guardduty.model.DefaultServerSideEncryption.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultServerSideEncryption())
      .map(value =>
        zio.aws.guardduty.model.DefaultServerSideEncryption.wrap(value)
      )
    override val publicAccess
        : Optional[zio.aws.guardduty.model.PublicAccess.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicAccess())
        .map(value => zio.aws.guardduty.model.PublicAccess.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.S3BucketDetail
  ): zio.aws.guardduty.model.S3BucketDetail.ReadOnly = new Wrapper(impl)
}
