package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class S3LogsConfiguration(enable: Boolean) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.S3LogsConfiguration = {
    import S3LogsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.S3LogsConfiguration
      .builder()
      .enable(enable: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.S3LogsConfiguration.ReadOnly =
    zio.aws.guardduty.model.S3LogsConfiguration.wrap(buildAwsValue())
}
object S3LogsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.S3LogsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.S3LogsConfiguration =
      zio.aws.guardduty.model.S3LogsConfiguration(enable)
    def enable: Boolean
    def getEnable: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.S3LogsConfiguration
  ) extends zio.aws.guardduty.model.S3LogsConfiguration.ReadOnly {
    override val enable: Boolean = impl.enable(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.S3LogsConfiguration
  ): zio.aws.guardduty.model.S3LogsConfiguration.ReadOnly = new Wrapper(impl)
}
