package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class S3LogsConfigurationResult(
    status: zio.aws.guardduty.model.DataSourceStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.S3LogsConfigurationResult = {
    import S3LogsConfigurationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.S3LogsConfigurationResult
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.S3LogsConfigurationResult.ReadOnly =
    zio.aws.guardduty.model.S3LogsConfigurationResult.wrap(buildAwsValue())
}
object S3LogsConfigurationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.S3LogsConfigurationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.S3LogsConfigurationResult =
      zio.aws.guardduty.model.S3LogsConfigurationResult(status)
    def status: zio.aws.guardduty.model.DataSourceStatus
    def getStatus: ZIO[Any, Nothing, zio.aws.guardduty.model.DataSourceStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.S3LogsConfigurationResult
  ) extends zio.aws.guardduty.model.S3LogsConfigurationResult.ReadOnly {
    override val status: zio.aws.guardduty.model.DataSourceStatus =
      zio.aws.guardduty.model.DataSourceStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.S3LogsConfigurationResult
  ): zio.aws.guardduty.model.S3LogsConfigurationResult.ReadOnly = new Wrapper(
    impl
  )
}
