package zio.aws.guardduty.model
import zio.aws.guardduty.model.primitives.{
  PositiveLong,
  AccountId,
  DetectorId,
  Timestamp,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Scan(
    detectorId: Optional[DetectorId] = Optional.Absent,
    adminDetectorId: Optional[DetectorId] = Optional.Absent,
    scanId: Optional[NonEmptyString] = Optional.Absent,
    scanStatus: Optional[zio.aws.guardduty.model.ScanStatus] = Optional.Absent,
    failureReason: Optional[NonEmptyString] = Optional.Absent,
    scanStartTime: Optional[Timestamp] = Optional.Absent,
    scanEndTime: Optional[Timestamp] = Optional.Absent,
    triggerDetails: Optional[zio.aws.guardduty.model.TriggerDetails] =
      Optional.Absent,
    resourceDetails: Optional[zio.aws.guardduty.model.ResourceDetails] =
      Optional.Absent,
    scanResultDetails: Optional[zio.aws.guardduty.model.ScanResultDetails] =
      Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    totalBytes: Optional[PositiveLong] = Optional.Absent,
    fileCount: Optional[PositiveLong] = Optional.Absent,
    attachedVolumes: Optional[Iterable[zio.aws.guardduty.model.VolumeDetail]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.guardduty.model.Scan = {
    import Scan.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Scan
      .builder()
      .optionallyWith(
        detectorId.map(value => DetectorId.unwrap(value): java.lang.String)
      )(_.detectorId)
      .optionallyWith(
        adminDetectorId.map(value => DetectorId.unwrap(value): java.lang.String)
      )(_.adminDetectorId)
      .optionallyWith(
        scanId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.scanId)
      .optionallyWith(scanStatus.map(value => value.unwrap))(_.scanStatus)
      .optionallyWith(
        failureReason.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        scanStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.scanStartTime)
      .optionallyWith(
        scanEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.scanEndTime)
      .optionallyWith(triggerDetails.map(value => value.buildAwsValue()))(
        _.triggerDetails
      )
      .optionallyWith(resourceDetails.map(value => value.buildAwsValue()))(
        _.resourceDetails
      )
      .optionallyWith(scanResultDetails.map(value => value.buildAwsValue()))(
        _.scanResultDetails
      )
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        totalBytes.map(value => PositiveLong.unwrap(value): java.lang.Long)
      )(_.totalBytes)
      .optionallyWith(
        fileCount.map(value => PositiveLong.unwrap(value): java.lang.Long)
      )(_.fileCount)
      .optionallyWith(
        attachedVolumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachedVolumes)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Scan.ReadOnly =
    zio.aws.guardduty.model.Scan.wrap(buildAwsValue())
}
object Scan {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.guardduty.model.Scan] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Scan = zio.aws.guardduty.model.Scan(
      detectorId.map(value => value),
      adminDetectorId.map(value => value),
      scanId.map(value => value),
      scanStatus.map(value => value),
      failureReason.map(value => value),
      scanStartTime.map(value => value),
      scanEndTime.map(value => value),
      triggerDetails.map(value => value.asEditable),
      resourceDetails.map(value => value.asEditable),
      scanResultDetails.map(value => value.asEditable),
      accountId.map(value => value),
      totalBytes.map(value => value),
      fileCount.map(value => value),
      attachedVolumes.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def detectorId: Optional[DetectorId]
    def adminDetectorId: Optional[DetectorId]
    def scanId: Optional[NonEmptyString]
    def scanStatus: Optional[zio.aws.guardduty.model.ScanStatus]
    def failureReason: Optional[NonEmptyString]
    def scanStartTime: Optional[Timestamp]
    def scanEndTime: Optional[Timestamp]
    def triggerDetails
        : Optional[zio.aws.guardduty.model.TriggerDetails.ReadOnly]
    def resourceDetails
        : Optional[zio.aws.guardduty.model.ResourceDetails.ReadOnly]
    def scanResultDetails
        : Optional[zio.aws.guardduty.model.ScanResultDetails.ReadOnly]
    def accountId: Optional[AccountId]
    def totalBytes: Optional[PositiveLong]
    def fileCount: Optional[PositiveLong]
    def attachedVolumes
        : Optional[List[zio.aws.guardduty.model.VolumeDetail.ReadOnly]]
    def getDetectorId: ZIO[Any, AwsError, DetectorId] =
      AwsError.unwrapOptionField("detectorId", detectorId)
    def getAdminDetectorId: ZIO[Any, AwsError, DetectorId] =
      AwsError.unwrapOptionField("adminDetectorId", adminDetectorId)
    def getScanId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("scanId", scanId)
    def getScanStatus: ZIO[Any, AwsError, zio.aws.guardduty.model.ScanStatus] =
      AwsError.unwrapOptionField("scanStatus", scanStatus)
    def getFailureReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getScanStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scanStartTime", scanStartTime)
    def getScanEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scanEndTime", scanEndTime)
    def getTriggerDetails
        : ZIO[Any, AwsError, zio.aws.guardduty.model.TriggerDetails.ReadOnly] =
      AwsError.unwrapOptionField("triggerDetails", triggerDetails)
    def getResourceDetails
        : ZIO[Any, AwsError, zio.aws.guardduty.model.ResourceDetails.ReadOnly] =
      AwsError.unwrapOptionField("resourceDetails", resourceDetails)
    def getScanResultDetails: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.ScanResultDetails.ReadOnly
    ] = AwsError.unwrapOptionField("scanResultDetails", scanResultDetails)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getTotalBytes: ZIO[Any, AwsError, PositiveLong] =
      AwsError.unwrapOptionField("totalBytes", totalBytes)
    def getFileCount: ZIO[Any, AwsError, PositiveLong] =
      AwsError.unwrapOptionField("fileCount", fileCount)
    def getAttachedVolumes: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.VolumeDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("attachedVolumes", attachedVolumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Scan
  ) extends zio.aws.guardduty.model.Scan.ReadOnly {
    override val detectorId: Optional[DetectorId] = zio.aws.core.internal
      .optionalFromNullable(impl.detectorId())
      .map(value => zio.aws.guardduty.model.primitives.DetectorId(value))
    override val adminDetectorId: Optional[DetectorId] = zio.aws.core.internal
      .optionalFromNullable(impl.adminDetectorId())
      .map(value => zio.aws.guardduty.model.primitives.DetectorId(value))
    override val scanId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.scanId())
      .map(value => zio.aws.guardduty.model.primitives.NonEmptyString(value))
    override val scanStatus: Optional[zio.aws.guardduty.model.ScanStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanStatus())
        .map(value => zio.aws.guardduty.model.ScanStatus.wrap(value))
    override val failureReason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.guardduty.model.primitives.NonEmptyString(value))
    override val scanStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.scanStartTime())
      .map(value => zio.aws.guardduty.model.primitives.Timestamp(value))
    override val scanEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.scanEndTime())
      .map(value => zio.aws.guardduty.model.primitives.Timestamp(value))
    override val triggerDetails
        : Optional[zio.aws.guardduty.model.TriggerDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.triggerDetails())
        .map(value => zio.aws.guardduty.model.TriggerDetails.wrap(value))
    override val resourceDetails
        : Optional[zio.aws.guardduty.model.ResourceDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceDetails())
        .map(value => zio.aws.guardduty.model.ResourceDetails.wrap(value))
    override val scanResultDetails
        : Optional[zio.aws.guardduty.model.ScanResultDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanResultDetails())
        .map(value => zio.aws.guardduty.model.ScanResultDetails.wrap(value))
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.guardduty.model.primitives.AccountId(value))
    override val totalBytes: Optional[PositiveLong] = zio.aws.core.internal
      .optionalFromNullable(impl.totalBytes())
      .map(value => zio.aws.guardduty.model.primitives.PositiveLong(value))
    override val fileCount: Optional[PositiveLong] = zio.aws.core.internal
      .optionalFromNullable(impl.fileCount())
      .map(value => zio.aws.guardduty.model.primitives.PositiveLong(value))
    override val attachedVolumes
        : Optional[List[zio.aws.guardduty.model.VolumeDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachedVolumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.VolumeDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Scan
  ): zio.aws.guardduty.model.Scan.ReadOnly = new Wrapper(impl)
}
