package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ScanCondition(
    mapEquals: Iterable[zio.aws.guardduty.model.ScanConditionPair]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ScanCondition = {
    import ScanCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ScanCondition
      .builder()
      .mapEquals(mapEquals.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ScanCondition.ReadOnly =
    zio.aws.guardduty.model.ScanCondition.wrap(buildAwsValue())
}
object ScanCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ScanCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ScanCondition =
      zio.aws.guardduty.model.ScanCondition(mapEquals.map { item =>
        item.asEditable
      })
    def mapEquals: List[zio.aws.guardduty.model.ScanConditionPair.ReadOnly]
    def getMapEquals: ZIO[Any, Nothing, List[
      zio.aws.guardduty.model.ScanConditionPair.ReadOnly
    ]] = ZIO.succeed(mapEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ScanCondition
  ) extends zio.aws.guardduty.model.ScanCondition.ReadOnly {
    override val mapEquals
        : List[zio.aws.guardduty.model.ScanConditionPair.ReadOnly] = impl
      .mapEquals()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.ScanConditionPair.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ScanCondition
  ): zio.aws.guardduty.model.ScanCondition.ReadOnly = new Wrapper(impl)
}
