package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class ScanConditionPair(
    key: TagKey,
    value: Optional[TagValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ScanConditionPair = {
    import ScanConditionPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ScanConditionPair
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ScanConditionPair.ReadOnly =
    zio.aws.guardduty.model.ScanConditionPair.wrap(buildAwsValue())
}
object ScanConditionPair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ScanConditionPair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ScanConditionPair =
      zio.aws.guardduty.model.ScanConditionPair(key, value.map(value => value))
    def key: TagKey
    def value: Optional[TagValue]
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ScanConditionPair
  ) extends zio.aws.guardduty.model.ScanConditionPair.ReadOnly {
    override val key: TagKey =
      zio.aws.guardduty.model.primitives.TagKey(impl.key())
    override val value: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.guardduty.model.primitives.TagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ScanConditionPair
  ): zio.aws.guardduty.model.ScanConditionPair.ReadOnly = new Wrapper(impl)
}
