package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait ScanCriterionKey {
  def unwrap: software.amazon.awssdk.services.guardduty.model.ScanCriterionKey
}
object ScanCriterionKey {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.ScanCriterionKey
  ): zio.aws.guardduty.model.ScanCriterionKey = value match {
    case software.amazon.awssdk.services.guardduty.model.ScanCriterionKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.ScanCriterionKey.EC2_INSTANCE_TAG =>
      val r = EC2_INSTANCE_TAG
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.guardduty.model.ScanCriterionKey {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ScanCriterionKey =
      software.amazon.awssdk.services.guardduty.model.ScanCriterionKey.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2_INSTANCE_TAG
      extends zio.aws.guardduty.model.ScanCriterionKey {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ScanCriterionKey =
      software.amazon.awssdk.services.guardduty.model.ScanCriterionKey.EC2_INSTANCE_TAG
  }
}
