package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ScanDetections(
    scannedItemCount: Optional[zio.aws.guardduty.model.ScannedItemCount] =
      Optional.Absent,
    threatsDetectedItemCount: Optional[
      zio.aws.guardduty.model.ThreatsDetectedItemCount
    ] = Optional.Absent,
    highestSeverityThreatDetails: Optional[
      zio.aws.guardduty.model.HighestSeverityThreatDetails
    ] = Optional.Absent,
    threatDetectedByName: Optional[
      zio.aws.guardduty.model.ThreatDetectedByName
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ScanDetections = {
    import ScanDetections.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ScanDetections
      .builder()
      .optionallyWith(scannedItemCount.map(value => value.buildAwsValue()))(
        _.scannedItemCount
      )
      .optionallyWith(
        threatsDetectedItemCount.map(value => value.buildAwsValue())
      )(_.threatsDetectedItemCount)
      .optionallyWith(
        highestSeverityThreatDetails.map(value => value.buildAwsValue())
      )(_.highestSeverityThreatDetails)
      .optionallyWith(threatDetectedByName.map(value => value.buildAwsValue()))(
        _.threatDetectedByName
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ScanDetections.ReadOnly =
    zio.aws.guardduty.model.ScanDetections.wrap(buildAwsValue())
}
object ScanDetections {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ScanDetections
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ScanDetections =
      zio.aws.guardduty.model.ScanDetections(
        scannedItemCount.map(value => value.asEditable),
        threatsDetectedItemCount.map(value => value.asEditable),
        highestSeverityThreatDetails.map(value => value.asEditable),
        threatDetectedByName.map(value => value.asEditable)
      )
    def scannedItemCount
        : Optional[zio.aws.guardduty.model.ScannedItemCount.ReadOnly]
    def threatsDetectedItemCount
        : Optional[zio.aws.guardduty.model.ThreatsDetectedItemCount.ReadOnly]
    def highestSeverityThreatDetails: Optional[
      zio.aws.guardduty.model.HighestSeverityThreatDetails.ReadOnly
    ]
    def threatDetectedByName
        : Optional[zio.aws.guardduty.model.ThreatDetectedByName.ReadOnly]
    def getScannedItemCount: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.ScannedItemCount.ReadOnly
    ] = AwsError.unwrapOptionField("scannedItemCount", scannedItemCount)
    def getThreatsDetectedItemCount: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.ThreatsDetectedItemCount.ReadOnly
    ] = AwsError.unwrapOptionField(
      "threatsDetectedItemCount",
      threatsDetectedItemCount
    )
    def getHighestSeverityThreatDetails: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.HighestSeverityThreatDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "highestSeverityThreatDetails",
      highestSeverityThreatDetails
    )
    def getThreatDetectedByName: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.ThreatDetectedByName.ReadOnly
    ] = AwsError.unwrapOptionField("threatDetectedByName", threatDetectedByName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ScanDetections
  ) extends zio.aws.guardduty.model.ScanDetections.ReadOnly {
    override val scannedItemCount
        : Optional[zio.aws.guardduty.model.ScannedItemCount.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scannedItemCount())
        .map(value => zio.aws.guardduty.model.ScannedItemCount.wrap(value))
    override val threatsDetectedItemCount
        : Optional[zio.aws.guardduty.model.ThreatsDetectedItemCount.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threatsDetectedItemCount())
        .map(value =>
          zio.aws.guardduty.model.ThreatsDetectedItemCount.wrap(value)
        )
    override val highestSeverityThreatDetails: Optional[
      zio.aws.guardduty.model.HighestSeverityThreatDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.highestSeverityThreatDetails())
      .map(value =>
        zio.aws.guardduty.model.HighestSeverityThreatDetails.wrap(value)
      )
    override val threatDetectedByName
        : Optional[zio.aws.guardduty.model.ThreatDetectedByName.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threatDetectedByName())
        .map(value => zio.aws.guardduty.model.ThreatDetectedByName.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ScanDetections
  ): zio.aws.guardduty.model.ScanDetections.ReadOnly = new Wrapper(impl)
}
