package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ScanEc2InstanceWithFindings(
    ebsVolumes: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ScanEc2InstanceWithFindings = {
    import ScanEc2InstanceWithFindings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ScanEc2InstanceWithFindings
      .builder()
      .optionallyWith(ebsVolumes.map(value => value: java.lang.Boolean))(
        _.ebsVolumes
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ScanEc2InstanceWithFindings.ReadOnly =
    zio.aws.guardduty.model.ScanEc2InstanceWithFindings.wrap(buildAwsValue())
}
object ScanEc2InstanceWithFindings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ScanEc2InstanceWithFindings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ScanEc2InstanceWithFindings =
      zio.aws.guardduty.model
        .ScanEc2InstanceWithFindings(ebsVolumes.map(value => value))
    def ebsVolumes: Optional[Boolean]
    def getEbsVolumes: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsVolumes", ebsVolumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ScanEc2InstanceWithFindings
  ) extends zio.aws.guardduty.model.ScanEc2InstanceWithFindings.ReadOnly {
    override val ebsVolumes: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsVolumes())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ScanEc2InstanceWithFindings
  ): zio.aws.guardduty.model.ScanEc2InstanceWithFindings.ReadOnly = new Wrapper(
    impl
  )
}
