package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ScanEc2InstanceWithFindingsResult(
    ebsVolumes: Optional[zio.aws.guardduty.model.EbsVolumesResult] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ScanEc2InstanceWithFindingsResult = {
    import ScanEc2InstanceWithFindingsResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ScanEc2InstanceWithFindingsResult
      .builder()
      .optionallyWith(ebsVolumes.map(value => value.buildAwsValue()))(
        _.ebsVolumes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.ScanEc2InstanceWithFindingsResult.ReadOnly =
    zio.aws.guardduty.model.ScanEc2InstanceWithFindingsResult
      .wrap(buildAwsValue())
}
object ScanEc2InstanceWithFindingsResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ScanEc2InstanceWithFindingsResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ScanEc2InstanceWithFindingsResult =
      zio.aws.guardduty.model.ScanEc2InstanceWithFindingsResult(
        ebsVolumes.map(value => value.asEditable)
      )
    def ebsVolumes: Optional[zio.aws.guardduty.model.EbsVolumesResult.ReadOnly]
    def getEbsVolumes: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.EbsVolumesResult.ReadOnly
    ] = AwsError.unwrapOptionField("ebsVolumes", ebsVolumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ScanEc2InstanceWithFindingsResult
  ) extends zio.aws.guardduty.model.ScanEc2InstanceWithFindingsResult.ReadOnly {
    override val ebsVolumes
        : Optional[zio.aws.guardduty.model.EbsVolumesResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsVolumes())
        .map(value => zio.aws.guardduty.model.EbsVolumesResult.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ScanEc2InstanceWithFindingsResult
  ): zio.aws.guardduty.model.ScanEc2InstanceWithFindingsResult.ReadOnly =
    new Wrapper(impl)
}
