package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ScanFilePath(
    filePath: Optional[String] = Optional.Absent,
    volumeArn: Optional[String] = Optional.Absent,
    hash: Optional[String] = Optional.Absent,
    fileName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ScanFilePath = {
    import ScanFilePath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ScanFilePath
      .builder()
      .optionallyWith(filePath.map(value => value: java.lang.String))(
        _.filePath
      )
      .optionallyWith(volumeArn.map(value => value: java.lang.String))(
        _.volumeArn
      )
      .optionallyWith(hash.map(value => value: java.lang.String))(_.hash)
      .optionallyWith(fileName.map(value => value: java.lang.String))(
        _.fileName
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ScanFilePath.ReadOnly =
    zio.aws.guardduty.model.ScanFilePath.wrap(buildAwsValue())
}
object ScanFilePath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ScanFilePath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ScanFilePath =
      zio.aws.guardduty.model.ScanFilePath(
        filePath.map(value => value),
        volumeArn.map(value => value),
        hash.map(value => value),
        fileName.map(value => value)
      )
    def filePath: Optional[String]
    def volumeArn: Optional[String]
    def hash: Optional[String]
    def fileName: Optional[String]
    def getFilePath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("filePath", filePath)
    def getVolumeArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeArn", volumeArn)
    def getHash: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hash", hash)
    def getFileName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fileName", fileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ScanFilePath
  ) extends zio.aws.guardduty.model.ScanFilePath.ReadOnly {
    override val filePath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.filePath())
      .map(value => value: String)
    override val volumeArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeArn())
      .map(value => value: String)
    override val hash: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hash())
      .map(value => value: String)
    override val fileName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fileName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ScanFilePath
  ): zio.aws.guardduty.model.ScanFilePath.ReadOnly = new Wrapper(impl)
}
